package com.digiwin.athena.semc.mapper.bench;


import com.baomidou.mybatisplus.annotation.InterceptorIgnore;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.digiwin.athena.semc.entity.bench.JobBench;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 **/
public interface JobBenchMapper extends BaseMapper<JobBench> {


    /**
     *  查询工作台、泳道
     */
    List<JobBench> selectBenchList(@Param("idList") List<Long> idList, @Param("parentId") Long parentId, @Param("tenantId") String tenantId);

    /**
     *  根据模版ID查询工作台、泳道
     */
    @InterceptorIgnore(tenantLine = "true")
    List<JobBench> selectTempBench(@Param("templateIds") List<Long> templateIds);


    /**
     * 获取ISV模版下的工作台、泳道
     * @return
     */
    @InterceptorIgnore(tenantLine = "true")
    List<JobBench> selectBenchByTemp(@Param("parentIdList")List<Long> parentIdList,@Param("idList")List<Long> idList);


    /**
     *  根据名称查询工作台、泳道
     */
    JobBench checkBenchList(@Param("parentId") Long parentId, @Param("name") String name);

    /**
     * 获取ISV模版下的泳道
     * @return
     */
    @InterceptorIgnore(tenantLine = "true")
    List<JobBench> selectChildByTemp(@Param("parentId") Long parentId);


    /**
     *  查询工作台信息
     */
    @InterceptorIgnore(tenantLine = "true")
    List<JobBench> selectByParam(@Param("req") JobBench jobBench,@Param("userIdList")List<String> userIdList);


    /**
     * 获取租户工作台中排序最近的下标
     * @return
     */
    Integer getIndexByTen(@Param("tenantId") String tenantId);
}