package com.digiwin.athena.semc.mapper.bench;


import com.baomidou.mybatisplus.annotation.InterceptorIgnore;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.digiwin.athena.semc.entity.bench.SyncJobInfo;
import org.apache.ibatis.annotations.Param;

import java.util.Collection;
import java.util.List;

/**SyncJobInfoMapper
 **/
public interface SyncJobInfoMapper extends BaseMapper<SyncJobInfo> {

    /**
     * 查询作业信息，忽略租户
     */
    @InterceptorIgnore(tenantLine = "true")
    List<SyncJobInfo> selByCode(@Param("appId") String appId,@Param("jobCode") String jobCode);

    /**
     * 根据作业名称和作业编码查询作业信息
     * @param appId
     * @return
     */
    List<SyncJobInfo> selByNameCode(@Param("appId") String appId,@Param("nameCode") String nameCode);

    /**
     * 查询已集成作业的应用appId
     * @return
     */
    List<String>  getJobAppIdList(@Param("appIdList")List<String> appIdList);

    /**
     * 根据appId查询已集成作业
     * @return
     */
    List<SyncJobInfo> selByAppId(@Param("appIdList")List<String> appIdList);


    List<SyncJobInfo> queryAppAccountIds(@Param("appIdList") Collection<String> appIdList);
}