package com.digiwin.athena.semc.mapper.common;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.digiwin.athena.semc.entity.common.Folder;
import com.digiwin.athena.semc.vo.common.FolderLevelVo;
import com.digiwin.athena.semc.vo.common.ReportCountVo;
import com.digiwin.athena.semc.vo.portal.FineReportVo;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * @description: 树目录mapper
 * @createDate: 2023/5/26 13:51
 * @author: sunyfa
 */
public interface FolderMapper extends BaseMapper<Folder> {
    /**
     * @description: 查询当前父目录下所有子目录的最大顺序
     * @param
     * @return
     * @author: sunyfa
     */
    Integer queryMaxOrder(@Param("parentFolderId") Long parentFolderId);

    /**
     * @description: 保存目录对象并返回id
     * @param
     * @return 
     * @author: sunyfa
     */
    void insertFolder(Folder folder);

    /**
     * @description: 查询所有根目录
     * @param
     * @return 
     * @author: sunyfa
     */
    @Select("SELECT * FROM SEMC_FOLDER WHERE PARENT_FOLDER_ID IS NULL AND OBJ_TYPE = #{type} ORDER BY FOLDER_ORDER")
    List<Folder> qryAllParent(int type);

    /**
     * @description: 查询父目录下的所有子目录
     * @param
     * @return 
     * @author: sunyfa
     */
    @Select("SELECT * FROM SEMC_FOLDER WHERE PARENT_FOLDER_ID = #{parentFolderId} AND OBJ_TYPE = #{type} ORDER BY FOLDER_ORDER")
    List<Folder> qryChildren(int type, long parentFolderId);

    /**
     * 根据目录id查询所有当前目录及子目录
     *
     * @param type 业务类型
     * @param parentFolderId 父目录id
     * @return
     */
    @Select("select * from semc_folder where obj_type = #{type} and id = #{parentFolderId} " +
            "union all " +
            "select * from semc_folder where obj_type = #{type} and parent_folder_id = #{parentFolderId}" +
            "union all " +
            "select * from semc_folder where obj_type = #{type} and parent_folder_id in (select id from semc_folder where obj_type = #{type} and parent_folder_id = #{parentFolderId})")
    List<Folder> qryCurrentAndChildFolderList(int type, long parentFolderId);

    /**
     * 查询目录下报表数量
     *
     * @return
     */
    @Select("select folder_id as folderId, count(id) AS reportCount from semc_fine_report group by folder_id")
    List<ReportCountVo> queryFolderReportCount();

    /**
     * 根据目录id查询所有当前目录及父目录的层级
     *
     * @param type 业务类型
     * @param folderId 目录id
     * @return
     */
    @Select("select id as folderId, level from semc_folder where obj_type = #{type} and id = #{folderId} " +
            "union all " +
            "select parent_folder_id as folderId, level-1 from semc_folder where obj_type = #{type} and id = #{folderId} " +
            "union all " +
            "select parent_folder_id as folderId, level-1 from semc_folder where obj_type = #{type} and id = (select parent_folder_id from semc_folder where obj_type = #{type} and id = #{folderId})")
    List<FolderLevelVo> qryCurrentAndParentFolderList(int type, long folderId);



    /**
     * 帆软报表搜索
     * @param
     * @param name
     * @return
     */
    @Select("select *  from semc_fine_report where del_flag=0 " +
            "and  tenant_id = #{tenantId} and name like concat('%', #{name}, '%')"+
            "  order by ASCII(name)" +
            "  limit #{startNum},#{pageSize} ")
    List<FineReportVo> fineReportSearch(String name,String tenantId,Integer startNum,Integer pageSize);

    /**
     * 帆软报表搜索
     * @param
     * @param name
     * @return
     */
    @Select("select count(1)  from semc_fine_report where del_flag=0 " +
            "and  tenant_id = #{tenantId} and name like concat('%', #{name}, '%')")
    Integer countReportSearch(String name,String tenantId);


    /**
     * 帆软查询
     * @param name
     * @param tenantId
     * @param reportIdList
     * @return
     */
    List<FineReportVo> fineReportBy(String name,String tenantId,List<String> reportIdList);

}
