package com.digiwin.athena.semc.mapper.device;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.digiwin.athena.semc.dto.device.DeviceBindExportQueryDTO;
import com.digiwin.athena.semc.dto.device.DeviceBindQueryDTO;
import com.digiwin.athena.semc.dto.device.DeviceBindRecordVO;
import com.digiwin.athena.semc.entity.device.UserBindDevice;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @Author jf gui
 * @Description 账号设备绑定mapper
 */
@Mapper
public interface UserBindDeviceMapper extends BaseMapper<UserBindDevice> {

    Integer countList(@Param("req") DeviceBindQueryDTO req);

    List<DeviceBindRecordVO> selectByPageList(@Param("req") DeviceBindQueryDTO req);

    List<DeviceBindRecordVO> selectExportList(@Param("param") DeviceBindExportQueryDTO req,@Param("tenantId") String tenantId);

    List<DeviceBindRecordVO> selectDeviceByUserOrDevice(@Param("userId") String userId, @Param("deviceId") String deviceId, @Param("terminalType") Integer terminalType);

    List<DeviceBindRecordVO> selectByIds(@Param("idList") List<Long> ids);

    DeviceBindRecordVO selectDeviceByBindId(@Param("userId") long id);

    UserBindDevice findByUserAndDeviceId(@Param("userId") String userId, @Param("deviceId") String deviceId);

    Integer countByUserIdAndDeviceId(@Param("userId") String userId, @Param("deviceId") String deviceId);

    Integer countByTenantIdAndDeviceId(@Param("deviceId") String deviceId);

    Integer countByTenantIdAndUserIdOrTerminalType(@Param("userId") String userId, @Param("terminalType") Integer terminalType);

    int deleteBatchByIds(@Param("idList") List<Long> idList, @Param("userId") String userId);

    IPage<DeviceBindRecordVO> selectDeviceBindPage(Page page, @Param("param") DeviceBindQueryDTO param,@Param("tenantId") String tenantId);
}
