package com.digiwin.athena.semc.mapper.menu;

import com.baomidou.mybatisplus.annotation.InterceptorIgnore;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.digiwin.athena.semc.entity.menu.CustomizedMenuTemplate;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * 自定义菜单模板表(TCustomizedMenuTemplate)表数据库访问层
 *
 * @author sunqgz
 * @since 2023-11-08
 */
public interface CustomizedMenuTemplateMapper extends BaseMapper<CustomizedMenuTemplate> {

    /**
     * 分页查询模板列表
     *
     * @param templateName   模板名称
     * @param templateStatus 模板状态
     * @param startNum       起始下标
     * @param pageSize       页大小
     * @param tenantId       租户id
     * @return 返回
     */
    @InterceptorIgnore(tenantLine = "true")
    List<CustomizedMenuTemplate> queryTempPageList(@Param("templateName") String templateName, @Param("templateStatus") Integer templateStatus, @Param("startNum") Integer startNum, @Param("pageSize") Integer pageSize, @Param("tenantId") String tenantId);

    /**
     * 查询模板总数
     *
     * @param templateName   模板名称
     * @param templateStatus 模板状态
     * @param tenantId       租户id
     * @return 返回
     */
    @InterceptorIgnore(tenantLine = "true")
    int queryTempCount(@Param("templateName") String templateName, @Param("templateStatus") Integer templateStatus, @Param("tenantId") String tenantId);

    /**
     * 分页查询租户下模板列表
     *
     * @param templateName   模板名称
     * @param templateStatus 模板状态
     * @param startNum       起始下标
     * @param pageSize       页大小
     * @param tenantId       租户id
     * @return 返回
     */
    @InterceptorIgnore(tenantLine = "true")
    List<CustomizedMenuTemplate> queryTenantTempPageList(@Param("templateName") String templateName, @Param("templateStatus") Integer templateStatus, @Param("startNum") Integer startNum, @Param("pageSize") Integer pageSize, @Param("tenantId") String tenantId);

    /**
     * 查询租户下模板总数
     *
     * @param templateName   模板名称
     * @param templateStatus 模板状态
     * @param tenantId       租户id
     * @return 返回
     */
    @InterceptorIgnore(tenantLine = "true")
    int queryTenantTempCount(@Param("templateName") String templateName, @Param("templateStatus") Integer templateStatus, @Param("tenantId") String tenantId);

    /**
     * 查询已发布的模板列表
     *
     * @param tenantId 租户id
     * @param templateName 模板名称
     * @return 返回
     */
    @InterceptorIgnore(tenantLine = "true")
    List<CustomizedMenuTemplate> queryEnableTempList(@Param("templateName") String templateName, @Param("tenantId") String tenantId);

    /**
     * 查询租户下已发布的模板列表
     *
     * @param tenantId 租户id
     * @param templateName 模板名称
     * @return 返回
     */
    @InterceptorIgnore(tenantLine = "true")
    List<CustomizedMenuTemplate> queryTenantEnableTempList(@Param("templateName") String templateName, @Param("tenantId") String tenantId);

    /**
     * 检验模板名称是否存在
     *
     * @param templateName 模板名称
     * @param templateId 模板id
     * @param tenantId 租户id
     * @return 返回
     */
    @InterceptorIgnore(tenantLine = "true")
    @Select({
            "<script>",
            "SELECT * FROM t_customized_menu_template WHERE template_name = #{templateName} AND (t_customized_menu_template.tenant_id = #{tenantId} or t_customized_menu_template.tenant_id is null) " +
                    "<if test= \"templateId!=null\">",
            "and id != #{templateId}",
            "</if>",
            "</script>"
    })
    List<CustomizedMenuTemplate> validExist(@Param("templateName") String templateName, @Param("templateId") Long templateId, @Param("tenantId") String tenantId);

    /**
     * 根据组件id查询所属的菜单模板
     *
     * @param menuLabelType 组件类型 0:自定义组件 1:预设组件
     * @param menuLabelIdList 组件id列表
     * @param tenantId 租户id
     * @return 返回
     */
    List<CustomizedMenuTemplate> queryTempListByLabelId(@Param("menuLabelType") Integer menuLabelType, @Param("menuLabelIdList") List<Long> menuLabelIdList, @Param("tenantId") String tenantId);

    /**
     * 更新租户下其他模板的状态
     *
     * @param templateId 模板ID
     * @param status 状态
     * @param tenantId 租户ID
     * @return
     */
    Integer updateOtherTemplateStatus(@Param("templateId") Long templateId, @Param("status") Integer status, @Param("tenantId") String tenantId);

    /**
     * 查询租户下其他已发布状态的模板
     *
     * @param templateId
     * @param tenantId
     * @return
     */
    List<CustomizedMenuTemplate> queryOtherEnableTemplate(@Param("templateId") Long templateId, @Param("tenantId") String tenantId);
}