package com.digiwin.athena.semc.mapper.menu.manage;

import com.baomidou.mybatisplus.annotation.InterceptorIgnore;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.digiwin.athena.semc.entity.menu.manage.ManageMenuAuth;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * 管理后台菜单权限表数据库访问层
 *
 * @author sunqgz
 * @since 2024-08-26
 */
public interface ManageMenuAuthMapper extends BaseMapper<ManageMenuAuth> {

    /**
     * 根据菜单标识批量删除菜单权限
     *
     * @param menuKeyList 菜单标识
     * @return 返回
     */
    @InterceptorIgnore(tenantLine = "true")
    @Delete({
            "<script>",
            "DELETE FROM t_manage_menu_auth WHERE menu_key IN",
            "<foreach item='item' index='index' collection='menuKeyList' open='(' separator=',' close=')'>",
            "#{item}",
            "</foreach>",
            "</script>"
    })
    int deleteByMenuKeyList(List<String> menuKeyList);

    /**
     * 根据菜单标识查询菜单是否存在
     *
     * @param menuKeyList 菜单标识列表
     * @return 返回
     */
    @InterceptorIgnore(tenantLine = "true")
    @Select({
            "<script>",
            "select distinct menu_key from t_manage_menu_auth where menu_key IN ",
            "<foreach item='item' index='index' collection='menuKeyList' open='(' separator=',' close=')'>",
            "#{item}",
            "</foreach>",
            "</script>"
    })
    List<String> queryByMenuKeyList(List<String> menuKeyList);
}