package com.digiwin.athena.semc.mapper.menu.manage;

import com.baomidou.mybatisplus.annotation.InterceptorIgnore;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.digiwin.athena.semc.entity.menu.manage.ManageMenu;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Update;

import java.util.List;

/**
 * 管理后台基础菜单配置表(TManageMenu)表数据库访问层
 *
 * @author sungqz
 * @since 2024-09-30
 */
public interface ManageMenuMapper extends BaseMapper<ManageMenu> {

    /**
     * 根据菜单标识批量删除菜单
     *
     * @param menuKeyList 菜单标识
     * @return 返回
     */
    @InterceptorIgnore(tenantLine = "true")
    @Delete({
            "<script>",
            "DELETE FROM t_manage_menu WHERE menu_key IN",
            "<foreach item='item' index='index' collection='menuKeyList' open='(' separator=',' close=')'>",
            "#{item}",
            "</foreach>",
            "</script>"
    })
    int deleteByMenuKeyList(List<String> menuKeyList);

    /**
     * 新增数据
     *
     * @param manageMenu 实例对象
     * @return 影响行数
     */
    int insert(ManageMenu manageMenu);

    /**
     * 修改数据
     *
     * @param manageMenu 实例对象
     * @return 影响行数
     */
    int update(ManageMenu manageMenu);

    /**
     * 设置特殊租户和账号
     *
     * @param idList 主键id
     * @param tenantId 租户id
     * @param userId 用户id
     */
    @InterceptorIgnore(tenantLine = "true")
    @Update("<script> UPDATE t_manage_menu " +
            "SET tenant_id = #{tenantId}, belonging_users = #{userId} " +
            "WHERE id in <foreach collection ='idList' item ='id' index ='index' separator=',' open='(' close=')'> #{id} </foreach> </script>")
    void updateTenantIdByIdList(List<Long> idList, String tenantId, String userId);
}

