package com.digiwin.athena.semc.mapper.message;

import com.baomidou.mybatisplus.annotation.InterceptorIgnore;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.digiwin.athena.semc.entity.message.DingtalkTemplateRel;

import java.util.List;

/**
 * 钉钉关联人员表(TDingtalkTemplateRel)表数据库访问层
 *
 * @author sunqgz
 * @since 2024-01-09
 */
public interface DingtalkTemplateRelMapper extends BaseMapper<DingtalkTemplateRel> {

    /**
     * 根据条件查询数据
     *
     * @param tenantId 租户id
     * @param eventId  事件id
     * @param language 语系
     * @return 返回对象
     */
    @InterceptorIgnore(tenantLine = "true")
    List<DingtalkTemplateRel> queryDingTalkUserByCondition(String tenantId, String eventId, String language);
}

