package com.digiwin.athena.semc.mapper.message;

import com.baomidou.mybatisplus.annotation.InterceptorIgnore;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.digiwin.athena.semc.dto.message.TemplateRelReq;
import com.digiwin.athena.semc.entity.message.EmailTemplateRel;

import java.util.List;

/**
 * 邮件关联人员表(TEmailTemplateRel)表数据库访问层
 *
 * @author sungqz
 * @since 2024-01-09
 */
public interface EmailTemplateRelMapper extends BaseMapper<EmailTemplateRel> {

    /**
     * 根据条件查询数据
     *
     * @param tenantId 租户id
     * @param templateRelReq 条件
     * @return 返回对象
     */
    @InterceptorIgnore(tenantLine = "true")
    List<EmailTemplateRel> queryEmailByCondition(String tenantId, TemplateRelReq templateRelReq);
}

