package com.digiwin.athena.semc.mapper.message;

import com.baomidou.mybatisplus.annotation.InterceptorIgnore;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.digiwin.athena.semc.entity.message.MessageBlackWhite;

import java.util.List;

/**
 * 消息接收人黑白名单(TMessageBlackWhite)表数据库访问层
 *
 * @author sungqz
 * @since 2024-01-10
 */
public interface MessageBlackWhiteMapper extends BaseMapper<MessageBlackWhite> {
    /**
     * 根据条件查询数据
     *
     * @param tenantId 租户id
     * @param type     名单类型 0:黑名单 1:白名单
     * @param key      过滤关键字
     * @return 返回对象
     */
    @InterceptorIgnore(tenantLine = "true")
    List<MessageBlackWhite> queryUserListByCondition(String tenantId, Integer type, String key);

}

