package com.digiwin.athena.semc.mapper.message;

import com.baomidou.mybatisplus.annotation.InterceptorIgnore;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.digiwin.athena.semc.entity.message.MessageChannel;

/**
 * 消息发送渠道表(TMessageChannel)表数据库访问层
 *
 * @author sungqz
 * @since 2023-11-30
 */
public interface MessageChannelMapper extends BaseMapper<MessageChannel> {

    /**
     * 根据条件查询数据
     *
     * @param tenantId 租户id
     * @param userId 用户id
     * @param channelLevel 消息渠道应用级别
     * @return 返回对象
     */
    @InterceptorIgnore(tenantLine = "true")
    MessageChannel queryChannelByCondition(String tenantId, String userId, Integer channelLevel);


    /**
     * 根据条件查询消息渠道标识
     *
     * @param tenantId     租户id
     * @param userId       用户id
     * @param channelLevel 消息渠道应用级别
     * @return 返回对象
     */
    @InterceptorIgnore(tenantLine = "true")
    String queryChannelFlagByCondition(String tenantId, String userId, Integer channelLevel);
}

