package com.digiwin.athena.semc.mapper.message;

import com.baomidou.mybatisplus.annotation.InterceptorIgnore;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.digiwin.athena.semc.entity.message.MessageChannelTemplate;
import org.apache.ibatis.annotations.Update;

import java.time.LocalDateTime;
import java.util.List;

/**
 * 消息模板配置表数据库访问层
 *
 * @author sungqz
 * @since 2024-1-8
 */
public interface MessageChannelTemplateMapper extends BaseMapper<MessageChannelTemplate> {

    /**
     * 根据条件查询数据
     *
     * @param tenantId 租户id
     * @param remark 模板备注
     * @param channelFlag 渠道标识 email:邮件 sms:短信 wecom:企微 dingTalk:钉钉
     * @param eventIdList 事件id列表
     * @return 返回对象
     */
    @InterceptorIgnore(tenantLine = "true")
    List<MessageChannelTemplate> queryTemplateByCondition(String tenantId, String remark, String channelFlag, List<String> eventIdList);

    /**
     * 更新模板信息
     *
     * @param userId 用户id
     * @param userName 用户名称
     * @param templateId 主键id
     * @param updateTime 更新时间
     */
    @Update("<script> UPDATE t_message_channel_template " +
            "SET modify_user_id = #{userId}, modify_time = #{updateTime}, modify_user_name = #{userName} " +
            "WHERE id = #{templateId} </script>")
    void updateTemplateByCondition(String userId, String userName, LocalDateTime updateTime, Long templateId);
}

