package com.digiwin.athena.semc.mapper.message;

import com.baomidou.mybatisplus.annotation.InterceptorIgnore;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.digiwin.athena.semc.entity.message.SmsTemplateRel;

import java.util.List;

/**
 * 短信关联人员表(TSmsTemplateRel)表数据库访问层
 *
 * @author sungqz
 * @since 2024-01-09
 */
public interface SmsTemplateRelMapper extends BaseMapper<SmsTemplateRel> {

    /**
     * 根据条件查询数据
     *
     * @param tenantId 租户id
     * @param eventId  事件id
     * @param language 语系
     * @return 返回对象
     */
    @InterceptorIgnore(tenantLine = "true")
    List<SmsTemplateRel> queryTelephoneByCondition(String tenantId, String eventId, String language);
}

