package com.digiwin.athena.semc.mapper.message;

import com.baomidou.mybatisplus.annotation.InterceptorIgnore;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.digiwin.athena.semc.entity.message.ThirdMessageConfig;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * @description: 导入记录表mapper
 * @createDate: 2024/3/4
 * @author: sunqz
 */
public interface ThirdSystemMessageMapper extends BaseMapper<ThirdMessageConfig> {

    /**
     * 根据appCode查询当前应用的配置
     *
     * @param appCode 应用code
     * @return
     */
    @InterceptorIgnore(tenantLine = "true")
    @Select("select * from t_third_message_config where app_code = #{appCode} and application_app_id = #{appId}")
    List<ThirdMessageConfig> queryConfigByAppCode(String appCode,String appId);
}