package com.digiwin.athena.semc.mapper.message;

import com.baomidou.mybatisplus.annotation.InterceptorIgnore;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.digiwin.athena.semc.entity.message.WecomTemplateRel;

import java.util.List;

/**
 * 企微关联人员表(TWecomTemplateRel)表数据库访问层
 *
 * @author sunqgz
 * @since 2024-01-09
 */
public interface WecomTemplateRelMapper extends BaseMapper<WecomTemplateRel> {

    /**
     * 根据条件查询数据
     *
     * @param tenantId 租户id
     * @param eventId  事件id
     * @param language 语系
     * @return 返回对象
     */
    @InterceptorIgnore(tenantLine = "true")
    List<WecomTemplateRel> queryWeComUserByCondition(String tenantId, String eventId, String language);
}

