package com.digiwin.athena.semc.mapper.mobile;

import com.baomidou.mybatisplus.annotation.InterceptorIgnore;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.digiwin.athena.semc.entity.mobile.MobileDatasourceClassification;
import com.digiwin.athena.semc.entity.mobile.MobileDatasourceInfo;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;

import java.util.List;

/**
 * 自定义应用分类数据库访问层
 *
 * @author qutong
 * @since 2024-09-03
 */
public interface MobileDatasourceClassificationMapper extends BaseMapper<MobileDatasourceClassification> {

    /**
     * 查询应用分类
     *
     * @return 返回
     */
    @InterceptorIgnore(tenantLine = "true")
    @Select("select * from t_mobile_datasource_classification where default_flag = 1 or tenant_id = #{tenantId} order by priority desc,create_time asc")
    List<MobileDatasourceClassification> queryApplicationClassificationList(String tenantId);

    /**
     * 查询分类名称是否存在
     *
     * @return 返回
     */
    @InterceptorIgnore(tenantLine = "true")
    @Select({
            "<script>",
            "SELECT * FROM t_mobile_datasource_classification WHERE classification_name = #{name} AND default_flag = 1 " +
                    "<if test= \"id!=null\">",
            "and id != #{id}",
            "</if>",
            "UNION SELECT * FROM t_mobile_datasource_classification WHERE classification_name = #{name} AND tenant_id = #{tenantId} " +
                    "<if test= \"id!=null\">",
            "and id != #{id}",
            "</if>",
            "</script>"
    })
    List<MobileDatasourceClassification> existNameValid(String name, Long id, String tenantId);

    /**
     * 更新应用的类型
     *
     * @param id       类型id
     * @param modifyTime 修改时间
     * @param userId   用户id
     * @param tenantId 租户
     */
    @InterceptorIgnore(tenantLine = "true")
    @Update("update t_mobile_datasource_info set classification_id = 4, modify_user_id = #{userId}, modify_time = #{modifyTime} where classification_id = #{id} and tenant_id = #{tenantId}")
    void updateClassificationById(Long id, String modifyTime, String userId, String tenantId);

    @InterceptorIgnore(tenantLine = "true")
    MobileDatasourceClassification selectClassificationById(Long id);

    @InterceptorIgnore(tenantLine = "true")
    void updateClassificationInfo(MobileDatasourceClassification classification);

    List<MobileDatasourceInfo> selectMobileList(List<String> customAppIds);
}

