package com.digiwin.athena.semc.mapper.mobile;

import com.baomidou.mybatisplus.annotation.InterceptorIgnore;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.digiwin.athena.semc.entity.bench.SyncJobInfo;
import com.digiwin.athena.semc.entity.mobile.MobileDatasourceInfo;
import com.digiwin.athena.semc.vo.common.PermissionUserFunctionalDTO;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Update;

import java.time.LocalDateTime;
import java.util.List;

/**
 * 自定义应用数据库访问层
 *
 * @author qutong
 * @since 2024-09-03
 */
public interface MobileDatasourceInfoMapper extends BaseMapper<MobileDatasourceInfo> {

    /**
     * 批量更新状态
     *
     * @param idList 主键id列表
     * @param status 状态 0:未启用 1:已启用
     */
    @InterceptorIgnore(tenantLine = "true")
    @Update({
            "<script>",
            "update t_mobile_datasource_info set status = #{status}, modify_user_id = #{userId}, modify_time = #{time} " +
                    "WHERE tenant_id = #{tenantId} AND id IN",
            "<foreach item='item' index='index' collection='idList' open='(' separator=',' close=')'>",
            "#{item}",
            "</foreach>",
            "</script>"
    })
    void updateStatus(List<Long> idList, Integer status, String userId, String tenantId, LocalDateTime time);


    /**
     * 根据id查询应用列表
     * @param idList
     * @return
     */
    List<MobileDatasourceInfo> selectMobileList(@Param("idList") List<Long> idList);

    /**
     * 校验数据源名称是否重复
     * @param name
     * @param id
     * @return
     */
    int countByParam(@Param("name")String name,@Param("id") Long id,@Param("tenantId")String tenantId);

//    @InterceptorIgnore(tenantLine = "true")
    List<String> selectAllWorkId(PermissionUserFunctionalDTO permissionUserFunctionalDTO);

    void updateIamDate(MobileDatasourceInfo mobileCustomApplication);

    List<SyncJobInfo> queryWorkName(@Param("appId")String appId,@Param("workCode") String workCode);

    void updateByIdNeedNull(MobileDatasourceInfo mobileCustomApplication);
}

