package com.digiwin.athena.semc.mapper.mobile;

import com.baomidou.mybatisplus.annotation.InterceptorIgnore;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.digiwin.athena.semc.entity.mobile.MobilePortalInfoContent;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

@Mapper
@Repository
public interface MobilePortalInfoContentMapper extends BaseMapper<MobilePortalInfoContent> {

    /**
     * 查询门户内容
     *
     * @return
     */
    @InterceptorIgnore(tenantLine = "true")
    List<MobilePortalInfoContent> queryMobiePortalCont(@Param("id") Long id,
                                                       @Param("contentTypeList") List<Integer> contentTypeList);

    /**
     * 根据应用id查询门户内容
     * @param idList
     * @return
     */
    @InterceptorIgnore(tenantLine = "true")
    List<MobilePortalInfoContent> queryMobiePortalContByAppId(@Param("idList") List<Long> idList);

    /**
     *根据组件类型查询租户的布局内容
     * @return
     */
    List<MobilePortalInfoContent> queryPortalContent(@Param("contentTypeList") List<Integer> contentTypeList);

}
