package com.digiwin.athena.semc.mapper.mobile;

import com.baomidou.mybatisplus.annotation.InterceptorIgnore;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.digiwin.athena.semc.dto.portal.PortalInfoQueryReq;
import com.digiwin.athena.semc.entity.mobile.MobilePortalInfo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

@Mapper
@Repository
public interface MobilePortalInfoMapper extends BaseMapper<MobilePortalInfo> {


    /**
     * 查询全局默认门户
     *
     * @return
     */
    @InterceptorIgnore(tenantLine = "true")
    MobilePortalInfo  queryMobileDefPortal();

    /**
     * 查询租户默认门户
     *
     * @return
     */
    MobilePortalInfo queryMobileTentDefPortal();

    /**
     * 批量更新
     *
     * @return
     */
    Integer updateBat(@Param("idList") List<Long> idList, @Param("req") PortalInfoQueryReq req);
}
