package com.digiwin.athena.semc.mapper.module;

import com.baomidou.mybatisplus.annotation.InterceptorIgnore;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.digiwin.athena.semc.entity.module.ModuleInfo;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;


import java.util.List;

/**
 * @description: 模块信息mapper
 * @createDate: 2025/8/25 16:45
 * @author: lilliaancheng
 */
public interface ModuleInfoMapper extends BaseMapper<ModuleInfo> {

    @Select("select module_code,code,group_code,app_code,item_sort,group_sort,app_sort from semc_module_info where module_code  = #{moduleCode} AND tenant_id = #{tenantId}")
    List<ModuleInfo> queryByModuleCode(@Param("moduleCode")String moduleCode, @Param("tenantId")String tenantId);

    @InterceptorIgnore(tenantLine = "true")
    Integer batchInsert(List<ModuleInfo> req);

    @Delete("delete from semc_module_info where module_code  = #{moduleCode} AND tenant_id = #{tenantId}")
    Integer deleteByModuleCode(@Param("moduleCode")String moduleCode, @Param("tenantId")String tenantId);
}
