package com.digiwin.athena.semc.mapper.mongo;

import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.semc.entity.applink.AppLinkAccessDO;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.BulkOperations;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.stereotype.Repository;

import javax.annotation.Resource;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

/**
 *  @date 2022/12/23
 */
@Repository
public class AppLinkMongoMapper {

    @Resource
    private MongoTemplate appLinkMongoTemplate;

    private final static String COLLECTION_NAME  = "app_link_access";

    public void access(String appId){
        AppLinkAccessDO accessDO = new AppLinkAccessDO();
        accessDO.setTenantId(AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
        accessDO.setUserId(AppAuthContextHolder.getContext().getAuthoredUser().getUserId());
        accessDO.setAccessDate(LocalDateTime.now());
        accessDO.setAppId(appId);
        BulkOperations operations = appLinkMongoTemplate.bulkOps(BulkOperations.BulkMode.UNORDERED, COLLECTION_NAME);
        operations.insert(accessDO);
        operations.execute();
    }

    public List<Map> getLatestAccesses(){
        Aggregation agg = Aggregation.newAggregation(
                Aggregation.match(Criteria.where("tenantId").is(AppAuthContextHolder.getContext().getAuthoredUser().getTenantId())
                        .and("userId").is(AppAuthContextHolder.getContext().getAuthoredUser().getUserId())),
                Aggregation.group("appId").max("accessDate").as("accessDate"),
                Aggregation.project("appId","accessDate"),
                Aggregation.sort(Sort.Direction.DESC, "accessDate"),
                Aggregation.limit(3)
        );

        return appLinkMongoTemplate.aggregate(agg, COLLECTION_NAME, Map.class).getMappedResults();
    }
}
