package com.digiwin.athena.semc.mapper.news;

import com.baomidou.mybatisplus.annotation.InterceptorIgnore;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.digiwin.athena.semc.entity.news.NewsAnnouncementAut;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;

import java.util.List;

/**
 * 新闻公告权限表(TNewsAnnouncementAuth)表数据库访问层
 *
 * @author sungqz
 * @since 2024-05-14
 */
public interface NewsAnnouncementAuthMapper extends BaseMapper<NewsAnnouncementAut> {

    @InterceptorIgnore(tenantLine = "true")
    @Delete({
            "<script>",
            "DELETE FROM t_news_announcement_auth WHERE news_id IN",
            "<foreach item='item' index='index' collection='newsIdList' open='(' separator=',' close=')'>",
            "#{item}",
            "</foreach>",
            "</script>"
    })
    int deleteByNewsIdList(List<Long> newsIdList);

    @InterceptorIgnore(tenantLine = "true")
    @Delete({
            "<script>",
            "DELETE FROM t_news_announcement_auth WHERE news_id = #{newsId}",
            "</script>"
    })
    int deleteByNewsId(Long newsId);

    @InterceptorIgnore(tenantLine = "true")
    @Select({
            "<script>",
            "SELECT id, news_id, news_type_id, all_auth_flag, auth_id, auth_biz_id, auth_name, auth_type, tenant_id, create_time, modify_time, create_user_id, modify_user_id, del_time, del_flag, del_user_id FROM t_news_announcement_auth " +
                    "WHERE news_id IN",
            "<foreach item='item' index='index' collection='newsIdList' open='(' separator=',' close=')'>",
            "#{item}",
            "</foreach>",
            "</script>"
    })
    List<NewsAnnouncementAut> selectByNewsId(List<Long> newsIdList);

    /**
     * 更新公告的类型
     *
     * @param id 公告类型id
     * @param tenantId 租户
     */
    @InterceptorIgnore(tenantLine = "true")
    @Update("update t_news_announcement_auth set news_type_id = 4 where news_type_id = #{id}")
    void updateNewsTypeById(Long id, String tenantId);
}

