package com.digiwin.athena.semc.mapper.news;

import com.baomidou.mybatisplus.annotation.InterceptorIgnore;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.digiwin.athena.semc.dto.news.QueryMobileNewsListPageReq;
import com.digiwin.athena.semc.entity.news.NewsAnnouncement;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;
import org.springframework.data.repository.query.Param;

import java.time.LocalDateTime;
import java.util.List;

/**
 * 新闻公告表(NewsAnnouncement)表数据库访问层
 *
 * @author sungqz
 * @since 2024-05-13
 */
public interface NewsAnnouncementMapper extends BaseMapper<NewsAnnouncement> {

    /**
     * 批量更新公告状态
     *
     * @param idList 主键id列表
     * @param status 公告状态 0:未发布 1:已发布 2:已失效
     */
    @InterceptorIgnore(tenantLine = "true")
    @Update({
            "<script>",
            "update t_news_announcement set news_status = #{status}, modify_user_id = #{userId}, modify_time = #{time} " +
                    "WHERE tenant_id = #{tenantId} AND id IN",
            "<foreach item='item' index='index' collection='idList' open='(' separator=',' close=')'>",
            "#{item}",
            "</foreach>",
            "</script>"
    })
    void updatePublishStatus(List<Long> idList, Integer status, String userId, String tenantId, LocalDateTime time);

    @InterceptorIgnore(tenantLine = "true")
    @Select({
            "<script>",
            "select id, news_title, news_status, topped_flag, topped_time, summary, news_channel, news_effective_flag, news_effective_time, news_type_id,default_image_icon, cover_image_id, modified_flag,file_id, news_source," +
                    "third_news_id, third_app_id, third_app_code, create_time, create_time, modify_user_id, modify_time,publish_type,publish_id,publish_name " +
                    "from t_news_announcement " +
                    "where news_channel in (0,1) and (news_status = #{newsStatus} and news_effective_time &lt; #{currentTime} and news_end_time &gt; #{currentTime}) " +
                    "<if test= \"newsTypeId != null\"> " +
                    "and news_type_id = #{newsTypeId} " +
                    "</if> and id IN ",
            "<foreach item='item' index='index' collection='newsIdList' open='(' separator=',' close=')'>",
            "#{item}",
            "</foreach>",
            " order by topped_time DESC, news_effective_time DESC, create_time DESC",
            "</script>"
    })
    List<NewsAnnouncement> selectNewsAnnouncementList(Integer newsStatus, List<Long> newsIdList, Integer newsTypeId, String currentTime);


    @InterceptorIgnore(tenantLine = "true")
    @Select({
            "<script>",
            "select id,news_type_id " +
                    "from t_news_announcement " +
                    "where news_channel in (0,1) and (news_status = #{newsStatus} and news_effective_time &lt; #{currentTime} and news_end_time &gt; #{currentTime}) " +
                    "<if test= \"newsTypeId != null\"> " +
                    "and news_type_id = #{newsTypeId} " +
                    "</if> and id IN ",
            "<foreach item='item' index='index' collection='newsIdList' open='(' separator=',' close=')'>",
            "#{item}",
            "</foreach>",
            "</script>"
    })
    List<NewsAnnouncement> selectNewsAnnouncementIdList(Integer newsStatus, List<Long> newsIdList, Integer newsTypeId, String currentTime);

    @InterceptorIgnore(tenantLine = "true")
    @Select({
            "<script>",
            "SELECT id, news_title,news_source, news_status, news_effective_time, news_end_time, news_type_id, summary,default_image_icon,cover_image_id, topped_flag, topped_time, modified_flag, news_content, file_id, tenant_id, create_time, modify_time, create_user_id, modify_user_id, del_time, del_flag, del_user_id," +
                    "third_news_id,third_app_id,third_app_code,third_url,third_img_url,third_user_ids,third_news_html,publish_id,publish_name,publish_type, t_news_announcement.like_count,news_type_path,favorite_count FROM t_news_announcement WHERE id =#{id}",
            "</script>"
    })
    NewsAnnouncement selectNewsAnnouncementById(Long id);

    @InterceptorIgnore(tenantLine = "true")
    void thirdInsert(@Param("newsAnnouncement") NewsAnnouncement newsAnnouncement);


    @InterceptorIgnore(tenantLine = "true")
    void updateNewsAnnouncementById(@Param("newsAnnouncement") NewsAnnouncement newsAnnouncement);


    @InterceptorIgnore(tenantLine = "true")
    NewsAnnouncement selectByIdAndCode(@Param("third_news_id") String thirdNewsId, @Param("third_app_code") String appCode, @Param("tenantId") String tenantId);

    /**
     * @param newsAnnouncement
     * @return
     */
    @InterceptorIgnore(tenantLine = "true")
    List<NewsAnnouncement> selectAllNews(@Param("newsAnnouncement") NewsAnnouncement newsAnnouncement);

    /**
     * 更新公告已读人员数量
     *
     * @param id 主键id
     */
    @InterceptorIgnore(tenantLine = "true")
    @Update({
            "<script>",
            "update t_news_announcement set read_count = read_count + 1 WHERE id = #{id}",
            "</script>"
    })
    void updateReadCount(Long id);

    /**
     * 移动端-前台分页查询用户公告列表
     *
     * @param newsIdDistinctList  公告id列表
     * @param req         请求入参
     * @param startNum    当前页
     * @param pageSize    页大小
     * @param tenantId    租户id
     * @return 返回
     */
    @InterceptorIgnore(tenantLine = "true")
    List<NewsAnnouncement> queryMobileUserNewsListPage(@Param("newsIdDistinctList") List<Long> newsIdDistinctList, @Param("req") QueryMobileNewsListPageReq req, @Param("startNum") Integer startNum, @Param("pageSize") Integer pageSize, @Param("tenantId") String tenantId, @Param("currentTime") String currentTime);

    /**
     * 移动端-前台查询用户公告列表总数
     *
     * @param newsIdDistinctList  公告id列表
     * @param req  请求入参
     * @param tenantId  租户id
     * @return 返回
     */
    @InterceptorIgnore(tenantLine = "true")
    Integer queryMobileUserNewsListCount(@Param("newsIdDistinctList")List<Long> newsIdDistinctList, @Param("req") QueryMobileNewsListPageReq req, @Param("tenantId") String tenantId, @Param("currentTime") String currentTime);

    /**
     * 查询当前租户移动端公告列表
     *
     * @param currentTime 当前时间
     * @param tenantId    租户id
     * @return 查询结果
     */
    @InterceptorIgnore(tenantLine = "true")
    List<NewsAnnouncement> queryNewsListByCondition(@Param("currentTime") String currentTime, @Param("tenantId") String tenantId,@Param("newsChannelList")List<Integer> newsChannelList,@Param("newsSource") Integer newsSource);

    /**
     * 更新公告的类型
     *
     * @param id 公告类型id
     * @param tenantId 租户
     */
    @InterceptorIgnore(tenantLine = "true")
    @Update("update t_news_announcement set news_type_id = 4, news_type_path = 4 where news_type_id = #{id} and tenant_id = #{tenantId}")
    void updateNewsTypeById(Long id, String tenantId);
}

