package com.digiwin.athena.semc.mapper.news;

import com.baomidou.mybatisplus.annotation.InterceptorIgnore;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.digiwin.athena.semc.entity.news.NewsAnnouncementRead;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * 新闻公告已读表(TNewsAnnouncementRead)表数据库访问层
 *
 * @author sunqgz
 * @since 2024-05-15
 */
public interface NewsAnnouncementReadMapper extends BaseMapper<NewsAnnouncementRead> {

    @InterceptorIgnore(tenantLine = "true")
    @Delete({
            "<script>",
            "DELETE FROM t_news_announcement_read WHERE news_id IN",
            "<foreach item='item' index='index' collection='newsIdList' open='(' separator=',' close=')'>",
            "#{item}",
            "</foreach>",
            "</script>"
    })
    int deleteByNewsIdList(List<Long> newsIdList);

    /**
     * 新增已读记录
     *
     * @param newsAnnouncementRead 已读公告
     */
    void insertNewsRead(NewsAnnouncementRead newsAnnouncementRead);

    /**
     * 查询已读公告列表信息
     *
     * @param newsIdList 公告列表
     * @return
     */
    @InterceptorIgnore(tenantLine = "true")
    @Select({
            "<script>",
            "SELECT id, news_id, third_news_id, third_app_id, third_app_code, create_user_id, create_user_sid, create_user_name, " +
                    "third_user_id, tenant_id, create_time, modify_user_id, modify_time FROM t_news_announcement_read WHERE news_id IN",
            "<foreach item='item' index='index' collection='newsIdList' open='(' separator=',' close=')'>",
            "#{item}",
            "</foreach>",
            "</script>"
    })
    List<NewsAnnouncementRead> selectNewsAnnouncementReadList(List<Long> newsIdList);
}

