package com.digiwin.athena.semc.mapper.news;

import com.baomidou.mybatisplus.annotation.InterceptorIgnore;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.digiwin.athena.semc.entity.news.NewsAnnouncementType;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * 新闻公告类型表(TNewsAnnouncementType)表数据库访问层
 *
 * @author sungqz
 * @since 2024-05-13
 */
public interface NewsAnnouncementTypeMapper extends BaseMapper<NewsAnnouncementType> {

    /**
     * 查询公告类型
     *
     * @param id 公告类型id
     * @return 返回
     */
    @Select({
            "<script>",
            "select * from t_news_announcement_type where default_flag = 1 or tenant_id = #{tenantId} " +
                    "<if test= \"id!=null\">",
            "and parent_id = #{id}",
            "</if>",
            "</script>"
    })
    @InterceptorIgnore(tenantLine = "true")
    List<NewsAnnouncementType> queryNewsTypeListByParentId(String tenantId, Long id);

    /**
     * 根据主键id查询单个公告类型
     *
     * @param id 公告类型id
     * @return 返回
     */
    @InterceptorIgnore(tenantLine = "true")
    @Select("select * from t_news_announcement_type where id = #{id}")
    NewsAnnouncementType queryNewsTypeById(Long id);

    /**
     * 根据主键id查询子集公告类型
     *
     * @param id 公告类型id
     * @return 返回
     */
    @InterceptorIgnore(tenantLine = "true")
    @Select("select * from t_news_announcement_type where parent_id = #{id}")
    List<NewsAnnouncementType> queryByParentId(Long id);
}

