package com.digiwin.athena.semc.mapper.portal;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.digiwin.athena.semc.dto.portal.SaveReportUrlParamReq;
import com.digiwin.athena.semc.entity.portal.FineReport;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Update;

import java.util.List;

/**
 * @description: 帆软报表mapper
 * @createDate: 2023/5/26 13:57
 * @author: sunyfa
 */
public interface FineReportMapper extends BaseMapper<FineReport> {
    /**
     * @description: 查询当前目录下报表的最大顺序
     * @param
     * @return 
     * @author: sunyfa
     */
    Integer queryMaxOrder(@Param("folderId") Long folderId, @Param("tenantId") String tenantId);

    /**
     * @description: 保存报表对象并返回id
     * @param
     * @return 
     * @author: sunyfa
     */
    void insertFineReport(FineReport fineReport);

    /**
     * 更新帆软报表链接后缀
     *
     * @return
     */
    @Update("<script> UPDATE semc_fine_report " +
            "SET user_config_flag = #{saveReportUrlParamReq.userConfigFlag}, department_config_flag = #{saveReportUrlParamReq.departmentConfigFlag}, factory_config_name = #{saveReportUrlParamReq.factoryConfigName}, modify_time = now(), modify_user_id = #{userId} " +
            "WHERE id in <foreach collection ='ids' item ='id' index ='index' separator=',' open='(' close=')'> #{id} </foreach> </script>")
    void batchUpdateParam(SaveReportUrlParamReq saveReportUrlParamReq, List<Long> ids, String userId);
}
