package com.digiwin.athena.semc.mapper.portal;


import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.digiwin.athena.semc.entity.portal.LabelSystemAuth;
import com.digiwin.athena.semc.entity.portal.LabelSystemData;
import com.digiwin.athena.semc.entity.portal.LabelSystemSource;
import com.digiwin.athena.semc.vo.common.AuthSystemLabelReq;
import com.digiwin.athena.semc.vo.common.BizObjAuthRelBatchSystemVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 **/
public interface LabelSystemAuthMapper extends BaseMapper<LabelSystemAuth> {


    /**
     *  查询所有预设组件和自定义组件
     * @param tenantId
     * @return
     */
    List<BizObjAuthRelBatchSystemVo> selectByLabelList(@Param("tenantId")String tenantId);

    /**
     *  根据权限ID删除关联信息
     * @param authId
     * @return
     */
    Integer delLabelAuth(@Param("authId")Long authId);

    /**
     * 查询权限
     * @param authId 权限ID
     * @return
     */
    List<LabelSystemAuth> selectByAuth(@Param("authId")Long authId);

    /**
     * 批量保存权限
     * @param authList  权限ID
     * @return
     */
    Integer batchSaveAuth(@Param("authList")List<LabelSystemAuth> authList);

    /**
     *  查询所有预设组件和自定义组件
     * @param name
     * @param tenantId
     * @return
     */
    List<BizObjAuthRelBatchSystemVo> pageSelectAuthList(@Param("startNum") Integer startNum,
                                                        @Param("pageSize") Integer pageSize,
                                                       @Param("name") String name,
                                                        @Param("nameTw") String nameTw,
                                                       @Param("tenantId")String tenantId,
                                                        @Param("preList") List<LabelSystemSource> preList,
                                                        @Param("customList")List<LabelSystemSource> customList,
                                                        @Param("permSystemIdList")List<Long> permSystemIdList);
    /**
     *  统计预设组件和自定义组件
     * @param name
     * @param tenantId
     * @return
     */
    Long countAuthList(@Param("startNum") Integer startNum,
                                                        @Param("pageSize") Integer pageSize,
                                                        @Param("name") String name,
                                                         @Param("nameTw") String nameTw,
                                                        @Param("tenantId")String tenantId,
                                                        @Param("preList") List<LabelSystemSource> preList,
                                                        @Param("customList") List<LabelSystemSource> customList,
                                                        @Param("permSystemIdList")List<Long> permSystemIdList);


}