package com.digiwin.athena.semc.mapper.portal;


import com.baomidou.mybatisplus.annotation.InterceptorIgnore;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.digiwin.athena.semc.dto.portal.QueryLabelSystemReq;
import com.digiwin.athena.semc.entity.applink.AppLinkDTO;
import com.digiwin.athena.semc.entity.portal.LabelSystemData;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Set;

/**
 **/
public interface LabelSystemDataMapper extends BaseMapper<LabelSystemData> {


    /**
     * 校验数据源名称是否重复
     * @param name
     * @param id
     * @return
     */
    int countByParam(@Param("name")String name,@Param("id") Long id,@Param("tenantId")String tenantId);


    /**
     * 获取SSO中应用被数据源引用的数据源名称集合
     * @return
     */
    List<String>  getDataNameList(@Param("dataType")Integer dataType,@Param("appCode")String appCode);


    /**
     * 条件查询数据源
     * @param startNum
     * @param pageSize
     * @return
     */
    List<LabelSystemData> selectByPage(@Param("appCodeList")List<AppLinkDTO> appCodeList, @Param("req") QueryLabelSystemReq req, @Param("startNum")Integer startNum, @Param("pageSize")Integer pageSize,@Param("tenantId")String tenantId);

    /**
     * 条件查询数据源总数
     * @return
     */
    int selectCountBy(@Param("appCodeList")List<AppLinkDTO> appCodeList, @Param("req") QueryLabelSystemReq req,@Param("tenantId")String tenantId);

    /**
     * 查询数据源（忽略租户）
     */
    @InterceptorIgnore(tenantLine = "true")
    List<LabelSystemData> selByIds(@Param("ids") List<Long> ids);

    /**
     *
     * @param systemData
     * @return
     */
    LabelSystemData getByInit(@Param("req")LabelSystemData  systemData);

    /**
     * 根据组件id查询数据源信息
     *
     * @param ids 组件id集合
     * @return 返回
     */
    List<LabelSystemData> queryBySystemIdList(@Param("ids") Set<Long> ids);

    /**
     * 查询源应用为【鼎捷雅典娜APP】的数据源和组件信息
     *
     * @param systemIds 组件id集合
     * @param appCode 【鼎捷雅典娜APP】的应用编码
     * @return 返回
     */
    List<LabelSystemData> queryAthenaAppList(@Param("systemIds") List<Long> systemIds,@Param("appCode")String appCode);


    /**
     * 查询作业被引用的数据源
     * @return
     */
    List<LabelSystemData>  getDataByWork(@Param("dataType")Integer dataType,@Param("appCode")String appCode,@Param("workCodeList")List<String> workCodeList);

    /**
     * 根据组件id查询数据源信息
     *
     * @param componentSource 组件来源  0：自定义组件 1：预设组件
     * @param systemId 组件id
     * @param tenantId 租户id
     * @return 返回
     */
    List<LabelSystemData> querySystemDataBySystemId(@Param("componentSource") Integer componentSource, @Param("list") List<Long> systemId, @Param("tenantId")String tenantId);
}