package com.digiwin.athena.semc.mapper.portal;


import com.baomidou.mybatisplus.annotation.InterceptorIgnore;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.digiwin.athena.semc.entity.portal.LabelSystemPre;
import com.digiwin.athena.semc.vo.portal.LabelSystemAllVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Set;

/**
 **/
public interface LabelSystemPreMapper extends BaseMapper<LabelSystemPre> {

    /**
     * 根据名称或预设组件分类查询预设组件列表
     * @param tenantId 组件id
     * @param name 名称
     * @param nameTw 繁体名称
     * @return 返回
     */
    List<LabelSystemAllVo> queryPreSystem(@Param("tenantId") String tenantId, @Param("name")String name , @Param("nameTw")String nameTw, @Param("preDateTypeList") List<Integer> preDateTypeList,@Param("clientType") Integer clientType);

    /**
     * 查询所有自定义组件
     * @param tenantIds
     * @param name
     * @return
     */
    @InterceptorIgnore(tenantLine = "true")
    List<LabelSystemAllVo> queryCustomSystem(@Param("tenantIds") Set<String> tenantIds, @Param("name")String name, @Param("dataCategoryList")List<Integer> dataCategoryList,@Param("clientType") Integer clientType);


    /**
     * 查询预设组件的所有租户
     * @return
     */
    List<String> queryPreSystemTenant();


    /**
     * 根据数据类型查询初始化数据
     * @param dataType
     * @return
     */
    LabelSystemPre getInitByDataType(@Param("dataType") Integer dataType);

}