package com.digiwin.athena.semc.mapper.portal;


import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.annotation.InterceptorIgnore;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.digiwin.athena.semc.entity.applink.AppLinkDTO;
import com.digiwin.athena.semc.entity.portal.LabelSystemSource;
import com.digiwin.athena.semc.vo.common.BizObjAuthRelBatchSystemVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 **/
public interface LabelSystemSourceMapper extends BaseMapper<LabelSystemSource> {

    /**
     * 删除数据源相关信息
     */
    Integer delByDataIds(@Param("dataIds") List<Long> dataIds);

    /**
     * 根据组件ID删除数据源相关信息
     */
    @InterceptorIgnore(tenantLine = "true")
    Integer delBySystemId(@Param("systemId")Long systemId,@Param("componentSource") Integer componentSource);

    /**
     * 查询数据源相关信息
     */
    List<LabelSystemSource> selByDataIds(@Param("dataIds") List<Long> dataIds,@Param("componentSource") Integer componentSource);

    /**
     * 根据组件id查询对应数据源的Id
     * @return
     */
    @InterceptorIgnore(tenantLine = "true")
    List<LabelSystemSource> queryByCountDataId(@Param("systemId") Long systemId,@Param("componentSource") Integer componentSource);
    /**
     *  新增 数据源和组件关联关系数据
     * @param labelSystemSource
     */
    void insertBatch(@Param("list") List<LabelSystemSource> labelSystemSource);

    /**
     *  新增 数据源和组件关联关系数据逻 字段不同
     * @param labelSystemSource
     */
    void insertItemBatch(@Param("list") List<LabelSystemSource> labelSystemSource);

    /**
     * 查询组件、数据源是否存在关联
     * @param tenantId
     * @param systemId
     * @param componentSource
     * @return
     */
    List<JSONObject> listBySystemId(@Param("tenantId") String tenantId,
                                    @Param("systemId") Long systemId,
                                    @Param("componentSource") Integer componentSource);

    /**
     *  查询数据源信息
     * @param tenantId
     * @param componentSource
     * @return
     */
    List<JSONObject> listByCondition(@Param("tenantId") String tenantId,
                                     @Param("componentSource") Integer componentSource,
                                     @Param("list") List<Long> systemId);


    /**
     * 查询组件涉及数据源（忽略租户）
     */
    @InterceptorIgnore(tenantLine = "true")
    List<LabelSystemSource> selBySystemIds(@Param("systemIds") List<Long> systemIds,  @Param("componentSource") Integer componentSource);

    /**
     * 根据数据源信息查询关联关系信息
     */
    List<LabelSystemSource> listSourceByData(@Param("appCodeList") List<AppLinkDTO> appCodeList);


    /**
     * 根据组件查询数据源关联关系
     */
    List<LabelSystemSource> listSourceByLabel(@Param("labelList") List<BizObjAuthRelBatchSystemVo> labelList);
}