package com.digiwin.athena.semc.mapper.portal;


import com.baomidou.mybatisplus.annotation.InterceptorIgnore;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.digiwin.athena.semc.entity.portal.PortalInfo;
import com.digiwin.athena.semc.entity.portal.PortalInfoContent;
import com.digiwin.athena.semc.entity.temp.TemplatePortalInfoContent;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 **/
public interface PortalInfoContentMapper extends BaseMapper<PortalInfoContent> {

    /**
     * 查询内容被门户引用的情况
     * @param tenantId
     * @param contentIdList
     * @return
     */
    List<PortalInfoContent> selPortalConent(@Param("tenantId") String tenantId,@Param("contentIdList")List<Long> contentIdList,@Param("contentType") Integer contentType,@Param("dataType") Integer dataType);


    /**
     * 查询全局默认门户内容
     *
     * @return
     */
    @InterceptorIgnore(tenantLine = "true")
    List<PortalInfoContent>  queryPortalCont(@Param("portalId")  Long portalId,@Param("contentTypeList")List<Integer> contentTypeList);

    /**
     * 删除门户内容-忽略租户
     *
     * @return
     */
    @InterceptorIgnore(tenantLine = "true")
    Integer  delPortalCont(@Param("portalId")  Long portalId);


    /**
     * 批量保存门户布局内容
     *
     * @return
     */
    @InterceptorIgnore(tenantLine = "true")
    Integer batchInsert(@Param("req") List<PortalInfoContent> contentList, @Param("portalId")Long portalId, @Param("tenantId") String tenantId);


}