package com.digiwin.athena.semc.mapper.portal;


import com.baomidou.mybatisplus.annotation.InterceptorIgnore;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.digiwin.athena.semc.dto.portal.PortalInfoQueryReq;
import com.digiwin.athena.semc.entity.portal.PortalInfo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 *
 **/
public interface PortalInfoMapper extends BaseMapper<PortalInfo> {


    /**
     * 查询默认门户
     *
     * @return
     */
    @InterceptorIgnore(tenantLine = "true")
    List<PortalInfo> queryDefPortal(@Param("tenantId") String tenantId);

    /**
     * 查询租户默认门户
     *
     * @param tenantId 租户id
     * @param clientType 门户端 PC端：0，移动端：1
     * @return 返回
     */
    PortalInfo queryTentDefPortal(String tenantId, Integer clientType);

    /**
     * 查询系统的默认门户
     *
     * @param clientType 门户端 PC端：0，移动端：1
     * @return 返回
     */
    @InterceptorIgnore(tenantLine = "true")
    PortalInfo queryDefaultPortal(Integer clientType);

    /**
     * 批量更新
     *
     * @return
     */
    Integer updateBat(@Param("idList") List<Long> idList, @Param("req") PortalInfoQueryReq req);


    /**
     * 根据模版更新
     *
     * @return
     */
    Integer updateByTemp(@Param("templateIds") List<Long> templateIds, @Param("status") Integer status, @Param("modifyTime") String modifyTime);

    /**
     * 根据模版删除
     *
     * @return
     */
    Integer delByTemp(@Param("ids") List<Long> ids);


    /**
     * 根据模版查询模版下门户
     *
     * @return
     */
    List<Long> selByTemp(@Param("templateIds") List<Long> templateIds);


    /**
     * 无租户查询ISV账号配置的门户信息
     *
     * @param req
     * @return
     */
    @InterceptorIgnore(tenantLine = "true")
    List<PortalInfo> selectByISV(@Param("req") PortalInfoQueryReq req, @Param("userIdList") List<String> userIdList);

    /**
     * 根据门户ID查询门户信息（忽略租户）
     *
     * @return
     */
    @InterceptorIgnore(tenantLine = "true")
    PortalInfo getPortalById(@Param("id") Long id);

    /**
     * 全局通用门户的编辑
     *
     * @return
     */
    @InterceptorIgnore(tenantLine = "true")
    Integer upPortDefById(@Param("req") PortalInfo req);

    /**
     * 根据模版ID查询门户信息（忽略租户）
     *
     * @return
     */
    @InterceptorIgnore(tenantLine = "true")
    PortalInfo getPortalByTemp(@Param("templateId") Long templateId);
}