package com.digiwin.athena.semc.mapper.portal;


import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.digiwin.athena.semc.vo.portal.PortalLayoutCustomCustomQueryVO;
import com.digiwin.athena.semc.vo.portal.PortalLayoutCustomPreQueryVO;
import com.digiwin.athena.semc.entity.portal.PortalLayoutCustom;
import com.digiwin.athena.semc.vo.portal.PortalLayoutCustomVO;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 **/
public interface PortalLayoutCustomMapper extends BaseMapper<PortalLayoutCustom> {

    /**
     * 查询预设门户布局
     * @param tenantId
     * @return
     */
    List<PortalLayoutCustomPreQueryVO> listPre(@Param("tenantId") String tenantId);

    /**
     *  查询自定义门户布局
     * @param tenantId
     * @return
     */
    List<PortalLayoutCustomCustomQueryVO> listCustom(@Param("tenantId") String tenantId);


    /**
     *  添加门户布局初始数据
     * @param portalLayoutCustoms
     */
    void insertBatch(@Param("list") List<PortalLayoutCustomVO> portalLayoutCustoms);

    /**
     *  修改布局组件位置
     * @param portalLayoutCustom
     */
    void updateByCondition(PortalLayoutCustom portalLayoutCustom);

}