package com.digiwin.athena.semc.mapper.portal;

import com.baomidou.mybatisplus.annotation.InterceptorIgnore;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.digiwin.athena.semc.entity.portal.PreinstalledApplicationInstance;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * @description:
 * @createDate: 2023/6/5
 * @author: sungqz
 */
public interface PreinstalledApplicationInstanceMapper extends BaseMapper<PreinstalledApplicationInstance> {

    /**
     * 批量保存预设应用的实例
     *
     * @param instanceList 实例列表
     * @return
     */
    @InterceptorIgnore(tenantLine = "true")
    int batchInsertInstance(List<PreinstalledApplicationInstance> instanceList);

    /**
     * 更新应用模式
     *
     * @param instance 配置实例表
     * @return
     */
    void updatePreinstalledApplicationInstance(PreinstalledApplicationInstance instance);

    /**
     * 查询租户下预设的配置信息
     * @param tenantId
     * @param applicationIdList
     * @return
     */
    @InterceptorIgnore(tenantLine = "true")
    List<PreinstalledApplicationInstance> getPreInsBy(@Param("tenantId") String tenantId, @Param("applicationIdList")List<String> applicationIdList, @Param("appIdList") List<String> appIdList);

    @InterceptorIgnore(tenantLine = "true")
    @Select("select * from preinstalled_application_instance where app_id = #{appId} and preinstalled_application_id = #{id}")
    List<PreinstalledApplicationInstance> selectByAppId(String appId, Long id);
}
