package com.digiwin.athena.semc.mapper.portal;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.digiwin.athena.semc.entity.portal.PreinstalledApplication;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * @createDate: 2023/1/29 11:19
 * @author: sunyfa
 */
public interface PreinstalledApplicationMapper extends BaseMapper<PreinstalledApplication> {

    /**
     * 更新应用信息
     *
     * @param idList          配置id列表
     * @param userBindFlag    归户标识
     * @param linkDisplayFlag 是否显示在友情链接 0:否；1:是
     * @param tenantId 租户id
     * @return
     */
    void updateAppInfo(@Param("idList") List<Long> idList, @Param("userBindFlag") Integer userBindFlag, @Param("linkDisplayFlag") Integer linkDisplayFlag, @Param("tenantId") String tenantId);


    /**
     *  模糊搜索预设表
     * @param applicationName
     * @return
     */
    List<PreinstalledApplication> listByApplicationName(@Param("applicationName") String applicationName);

    /**
     * 根据code查询
     * @param appCode
     * @return
     */
    @Select("select * from preinstalled_application where application_code = #{appCode}")
    List<PreinstalledApplication>  getAllByAppCode(String appCode);

}
