package com.digiwin.athena.semc.mapper.portal;


import com.baomidou.mybatisplus.annotation.InterceptorIgnore;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.digiwin.athena.semc.entity.portal.TodoList;
import com.digiwin.athena.semc.proxy.iam.service.model.AppUserDTO;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * <p>
 * Mapper 接口
 * </p>
 *
 * @author zhangtuo
 * @since 2022-10-28
 */
public interface TodoListMapper extends BaseMapper<TodoList> {


    /**
     * 查询用户待办
     * @param todoList
     * @return
     */
    List<TodoList> selectByUser(@Param("todoList") TodoList todoList);

    /**
     * 查询用户待办梳理
     *
     * @param verifyUserIdList 应用id和用户id
     * @return
     */
    List<TodoList> queryToDoListByUserId(@Param("verifyUserIdList")List<AppUserDTO> verifyUserIdList);

    /**
     * 查询用户应用的待办数量
     *
     * @param appIdList 应用id和用户id
     * @return
     */
    @InterceptorIgnore(tenantLine = "true")
    List<TodoList> queryToDoNum(@Param("appIdList")List<String> appIdList,@Param("userIdList")List<String> userIdList);


}
