package com.digiwin.athena.semc.mapper.sso;


import com.baomidou.mybatisplus.annotation.InterceptorIgnore;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.digiwin.athena.semc.dto.erpsso.QuerySsoListReq;
import com.digiwin.athena.semc.entity.sso.ErpSsoInfo;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * <p>
 * Mapper 接口
 * </p>
 *
 * @author zhangtuo
 * @since 2022-10-28
 */
public interface ErpSsoInfoMapper extends BaseMapper<ErpSsoInfo> {

    /**
     * 更新生效状态
     *
     * @param ssoId  配置id
     * @param status 状态
     * @param userId 修改人id
     * @return
     */
    int updateStatusById(@Param("ssoId") Long ssoId, @Param("status") Integer status, @Param("userId") String userId);

    /**
     * 更新归户模式
     *
     * @param ssoIdList    配置id列表
     * @param userBindFlag 归户标识
     * @param userId       修改人id
     * @return
     */
    void updateBindFlag(@Param("ssoIdList") List<Long> ssoIdList, @Param("userBindFlag") Integer userBindFlag, @Param("userId") String userId);

    /**
     * 查询所有稳态应用列表
     *
     * @param querySsoListReq 请求参数
     * @return
     */
    @InterceptorIgnore(tenantLine = "true")
    List<ErpSsoInfo> querySsoListByScope(@Param("querySsoListReq") QuerySsoListReq querySsoListReq);

    /**
     * 根据appId查询租户
     *
     * @param appId 应用id
     * @return 返回
     */
    @InterceptorIgnore(tenantLine = "true")
    @Select("select tenant_id from t_erp_sso_info where app_id = #{appId}\n" +
            "union \n" +
            "select tenant_id from t_third_sso_info where app_id = #{appId}\n" +
            "union \n" +
            "select tenant_id from preinstalled_application_instance where app_id = #{appId}")
    List<String> queryTenantIdByAppId(String appId);


    /**
     *  模糊搜索CS数据
     * @param name
     * @param tenantId
     * @return
     */
    List<ErpSsoInfo> listByName(@Param("name") String name, @Param("tenantId") String tenantId);

    @InterceptorIgnore(tenantLine = "true")
    @Select("select * from t_erp_sso_info where code = #{appCode} and app_id = #{appId}")
    List<ErpSsoInfo> queryByAppCode(String appId,String appCode);

    @Select("select * from t_erp_sso_info where code = #{appCode} and del_flag=0 and valid_status = 1 limit 1")
    ErpSsoInfo queryAppConfigByAppCode(String appCode);
}
