package com.digiwin.athena.semc.mapper.sso;


import com.baomidou.mybatisplus.annotation.InterceptorIgnore;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.digiwin.athena.semc.dto.erpsso.QuerySsoListReq;
import com.digiwin.athena.semc.entity.sso.ThirdSsoInfo;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * <p>
 * Mapper 接口
 * </p>
 *
 * @author sungq
 * @since 2022-11-28
 */
public interface ThirdSsoInfoMapper extends BaseMapper<ThirdSsoInfo> {

    /**
     * 更新生效状态
     *
     * @param ssoId 配置id
     * @param status 状态
     * @param userId 修改人工号
     * @return
     */
    int updateThirdStatusById(@Param("ssoId") Long ssoId, @Param("status") Integer status, @Param("userId") String userId);

    /**
     * 更新归户模式
     *
     * @param ssoIdList 配置id列表
     * @param userBindFlag 归户标识
     * @param userId 修改人id
     * @return
     */
    void updateBindFlag(@Param("ssoIdList") List<Long> ssoIdList, @Param("userBindFlag") Integer userBindFlag, @Param("userId") String userId);

    /**
     * 查询敏态的应用列表
     *
     * @param querySsoListReq 请求实体
     * @return
     */
    @InterceptorIgnore(tenantLine = "true")
    List<ThirdSsoInfo> queryThirdListByScope(@Param("querySsoListReq") QuerySsoListReq querySsoListReq);


    /**
     * 查询敏态的应用列表
     *
     * @return
     */
    List<ThirdSsoInfo> querySsoInfoBy(@Param("appName")String appName);


    /**
     *  模糊搜索BS
     * @param name
     * @param tenantId
     * @return
     */
    List<ThirdSsoInfo> listByAppName(@Param("name")String name, @Param("tenantId") String tenantId);


    /**
     * 根据AppCode查询
     * @param appCode
     * @return
     */
    @InterceptorIgnore(tenantLine = "true")
    @Select("select * from t_third_sso_info where app_code = #{appCode} and app_id = #{appId}")
    List<ThirdSsoInfo> queryByAppCode(String appId,String appCode);

    /**
     * 根据AppCode查询
     * @param appCode
     * @return
     */
    @Select("select * from t_third_sso_info where app_code = #{appCode} and del_flag=0 and valid_status = 1 limit 1")
    ThirdSsoInfo queryAppConfigByAppCode(String appCode);
}
