package com.digiwin.athena.semc.mapper.temp;


import com.baomidou.mybatisplus.annotation.InterceptorIgnore;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.digiwin.athena.semc.entity.temp.TemplateBenchCustom;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 **/
public interface TemplateBenchCustomMapper extends BaseMapper<TemplateBenchCustom> {



    /**
     *  保存泳道和组件的关系
     * @param templateBenchCustoms
     */
    Integer insertBatch(@Param("list") List<TemplateBenchCustom> templateBenchCustoms);

    /**
     *  查询泳道下自定义组件信息
     */
    @InterceptorIgnore(tenantLine = "true")
    List<TemplateBenchCustom> selectBenchJob(@Param("systemIdList") List<Long> systemIdList, @Param("benchId") Long benchId);


    /**
     *  删除泳道下自定义组件
     */
    Integer  delBenchJob(@Param("benchIdList") List<Long> benchIdList);


    /**
     * 查询工作台下组件-忽略租户
     * @param benchIdList
     * @return
     */
    @InterceptorIgnore(tenantLine = "true")
    List<TemplateBenchCustom> selectBenchBy(@Param("benchIdList") List<Long> benchIdList,@Param("systemIdList") List<Long> systemIdList);
}