package com.digiwin.athena.semc.mapper.temp;


import com.baomidou.mybatisplus.annotation.InterceptorIgnore;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.digiwin.athena.semc.dto.portal.TemplateQueryReq;
import com.digiwin.athena.semc.entity.temp.TemplateInfo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 **/
public interface TemplateInfoMapper extends BaseMapper<TemplateInfo> {


    /**
     * 批量更新
     *
     * @return
     */
    @InterceptorIgnore(tenantLine = "true")
    Integer updateBat(@Param("idList") List<Long> idList, @Param("req")TemplateInfo req);

    /**
     *条件查询模版
     * @param req
     * @return
     */
    @InterceptorIgnore(tenantLine = "true")
    List<TemplateInfo> queryByTemp(@Param("req") TemplateQueryReq req,@Param("subTypeList") List<Integer> subTypeList);


    /**
     *获取类型模版
     * @param templateType
     * @return
     */
    @InterceptorIgnore(tenantLine = "true")
    TemplateInfo getByTemplateType(@Param("templateType") Integer templateType);



    /**
     *根据ID获取模版信息
     * @param
     * @return
     */
    @InterceptorIgnore(tenantLine = "true")
    TemplateInfo getTemplateById(@Param("id")Long  id);


    /**
     *根据编号和名称查询
     * @param req
     * @return
     */
    @InterceptorIgnore(tenantLine = "true")
    List<TemplateInfo> queryByParam(@Param("req") TemplateInfo req);


    /**
     * 更新模版信息，忽略租户
     * @return
     */
    @InterceptorIgnore(tenantLine = "true")
    Integer upTempById(@Param("req") TemplateInfo req);
}