package com.digiwin.athena.semc.mapper.temp;


import com.baomidou.mybatisplus.annotation.InterceptorIgnore;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.digiwin.athena.semc.entity.temp.TemplateInfoTenant;
import com.digiwin.athena.semc.entity.temp.TemplateTenantGroupItem;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 **/
public interface TemplateInfoTenantMapper extends BaseMapper<TemplateInfoTenant> {


    /**
     * 查询模版下分组数据
     *
     * @param templateIdList
     * @return
     */
    @InterceptorIgnore(tenantLine = "true")
    List<TemplateInfoTenant> selectByTemp(@Param("templateIdList") List<Long> templateIdList);


    /**
     * 批量删除模版下分组数据
     *
     * @param templateIdList
     * @return
     */
    @InterceptorIgnore(tenantLine = "true")
    Integer delByTemp(@Param("templateIdList") List<Long> templateIdList);

    /**
     * 删除模版中租户信息
     *
     * @param subUserId
     * @param groupTenantIds
     * @param selectType
     * @return
     */
    @InterceptorIgnore(tenantLine = "true")
    Integer delTenantBy(@Param("subUserId") String subUserId, @Param("groupTenantIds") List<String> groupTenantIds, @Param("selectType") Integer selectType);


    /**
     * 批量保存模版中的租户
     *
     * @param paramList
     * @return
     */
    Integer batchInsertTenant(@Param("req") List<TemplateInfoTenant> paramList,@Param("createUserId") String createUserId,@Param("createTime") String createTime);

}