package com.digiwin.athena.semc.mapper.temp;


import com.baomidou.mybatisplus.annotation.InterceptorIgnore;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.digiwin.athena.semc.entity.temp.TemplatePortalInfoContent;
import com.digiwin.athena.semc.entity.temp.TemplateTenantGroupItem;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 **/
public interface TemplatePortalInfoContentMapper extends BaseMapper<TemplatePortalInfoContent> {

    /**
     * 查询内容被门户引用的情况
     * @param tenantId
     * @param contentIdList
     * @return
     */
    List<TemplatePortalInfoContent> selPortalConent(@Param("tenantId") String tenantId, @Param("contentIdList") List<Long> contentIdList, @Param("contentType") Integer contentType);


    /**
     * 批量保存门户布局内容
     *
     * @param paramList
     * @return
     */
    Integer batchInsert(@Param("req") List<TemplatePortalInfoContent> paramList, @Param("portalId")Long portalId,@Param("tenantId") String tenantId);

    /**
     * 查询全局默认门户内容
     *
     * @return
     */
    @InterceptorIgnore(tenantLine = "true")
    List<TemplatePortalInfoContent>  queryPortalCont(@Param("portalId") Long portalId, @Param("contentTypeList") List<Integer> contentTypeList);

    /**
     * 删除门户内容-忽略租户
     *
     * @return
     */
    @InterceptorIgnore(tenantLine = "true")
    Integer  delPortalCont(@Param("portalId") Long portalId);

}