package com.digiwin.athena.semc.mapper.temp;


import com.baomidou.mybatisplus.annotation.InterceptorIgnore;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.digiwin.athena.semc.dto.portal.PortalInfoQueryReq;
import com.digiwin.athena.semc.entity.temp.TemplatePortalInfo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 **/
public interface TemplatePortalInfoMapper extends BaseMapper<TemplatePortalInfo> {


    /**
     * 查询全局默认门户
     *
     * @return
     */
    @InterceptorIgnore(tenantLine = "true")
    TemplatePortalInfo queryDefPortal();

    /**
     * 查询租户默认门户
     *
     * @return
     */
    TemplatePortalInfo queryTentDefPortal();

    /**
     * 批量更新
     *
     * @return
     */
    Integer updateBat(@Param("idList") List<Long> idList, @Param("req") PortalInfoQueryReq req);


    /**
     * 根据模版更新
     *
     * @return
     */
    Integer updateByTemp(@Param("templateIds") List<Long> templateIds, @Param("req") TemplatePortalInfo req);

    /**
     * 根据模版删除
     *
     * @return
     */
    Integer delByTemp(@Param("ids") List<Long> ids);


    /**
     * 根据模版查询模版下门户
     *
     * @return
     */
    List<Long> selByTemp(@Param("templateIds") List<Long> templateIds);


    /**
     * 无租户查询ISV账号配置的门户信息
     * @param req
     * @return
     */
    @InterceptorIgnore(tenantLine = "true")
    List<TemplatePortalInfo> selectByISV(@Param("req") PortalInfoQueryReq req, @Param("tempIdList") List<Long> tempIdList);

    /**
     * 根据门户ID查询门户信息（忽略租户）
     *
     * @return
     */
    @InterceptorIgnore(tenantLine = "true")
    TemplatePortalInfo getPortalById(@Param("id") Long id);

    /**
     * 全局通用门户的编辑
     * @return
     */
    @InterceptorIgnore(tenantLine = "true")
    Integer upPortDefById(@Param("req") TemplatePortalInfo req);

    /**
     * 根据模版ID查询门户信息（忽略租户）
     *
     * @return
     */
    @InterceptorIgnore(tenantLine = "true")
    TemplatePortalInfo getPortalByTemp(@Param("templateId") Long templateId);
}