package com.digiwin.athena.semc.mapper.temp;


import com.baomidou.mybatisplus.annotation.InterceptorIgnore;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.digiwin.athena.semc.dto.portal.QueryLabelSystemReq;
import com.digiwin.athena.semc.entity.applink.AppLinkDTO;
import com.digiwin.athena.semc.entity.temp.TemplateSystemData;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Set;

/**
 **/
public interface TemplateSystemDataMapper extends BaseMapper<TemplateSystemData> {


    /**
     * 校验数据源名称是否重复
     * @param name
     * @param id
     * @return
     */
    int countByParam(@Param("name") String name, @Param("id") Long id, @Param("tenantId") String tenantId);


    /**
     * 获取SSO中应用被数据源引用的数据源名称集合
     * @return
     */
    List<String>  getDataNameList(@Param("dataType") Integer dataType, @Param("appCode") String appCode);


    /**
     * 条件查询数据源
     * @param startNum
     * @param pageSize
     * @return
     */
    List<TemplateSystemData> selectByPage(@Param("appCodeList") List<AppLinkDTO> appCodeList, @Param("req") QueryLabelSystemReq req, @Param("startNum") Integer startNum, @Param("pageSize") Integer pageSize, @Param("tenantId") String tenantId);

    /**
     * 条件查询数据源总数
     * @return
     */
    int selectCountBy(@Param("appCodeList") List<AppLinkDTO> appCodeList, @Param("req") QueryLabelSystemReq req, @Param("tenantId") String tenantId);

    /**
     *  获取源应用
     * @param systemId
     * @param tenantId
     * @return
     */
    List<TemplateSystemData> getBySystemId(@Param("list") List<Long> systemId, @Param("tenantId") String tenantId);


    /**
     * 查询数据源（忽略租户）
     */
    @InterceptorIgnore(tenantLine = "true")
    List<TemplateSystemData> selByIds(@Param("ids") List<Long> ids);

    /**
     *
     * @param systemData
     * @return
     */
    TemplateSystemData getByInit(@Param("req") TemplateSystemData systemData);

    /**
     * 根据组件id查询数据源信息
     *
     * @param ids 组件id集合
     * @return 返回
     */
    List<TemplateSystemData> queryBySystemIdList(@Param("ids") Set<Long> ids);
}