package com.digiwin.athena.semc.mapper.temp;


import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.annotation.InterceptorIgnore;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.digiwin.athena.semc.entity.temp.TemplateSystemSource;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 **/
public interface TemplateSystemSourceMapper extends BaseMapper<TemplateSystemSource> {

    /**
     * 删除数据源相关信息
     */
    Integer delByDataIds(@Param("dataIds") List<Long> dataIds,@Param("systemId") Long systemId,
                         @Param("componentSource") Integer componentSource);


    /**
     * 查询数据源相关信息
     */
    List<TemplateSystemSource> selByDataIds(@Param("dataIds") List<Long> dataIds, @Param("componentSource") Integer componentSource);

    /**
     * 根据组件id查询对应数据源的Id
     * @return
     */
    @InterceptorIgnore(tenantLine = "true")
    List<TemplateSystemSource> queryByCountDataId(@Param("systemId") String systemId);
    /**
     *  新增 数据源和组件关联关系数据
     * @param tempSystemSource
     */
    void insertBatch(@Param("list") List<TemplateSystemSource> tempSystemSource);

    /**
     *  新增 数据源和组件关联关系数据逻 字段不同
     * @param tempSystemSource
     */
    void insertItemBatch(@Param("list") List<TemplateSystemSource> tempSystemSource);

    /**
     * 查询组件、数据源是否存在关联
     * @param tenantId
     * @param systemId
     * @param componentSource
     * @return
     */
    List<JSONObject> listBySystemId(@Param("tenantId") String tenantId,
                                    @Param("systemId") Long systemId,
                                    @Param("componentSource") Integer componentSource);

    /**
     *  查询数据源信息
     * @param tenantId
     * @param componentSource
     * @return
     */
    List<JSONObject> listByCondition(@Param("tenantId") String tenantId,
                                     @Param("componentSource") Integer componentSource,
                                     @Param("list") List<Long> systemId);


    /**
     * 查询组件涉及数据源（忽略租户）
     */
    @InterceptorIgnore(tenantLine = "true")
    List<TemplateSystemSource> selBySystemIds(@Param("systemIds") List<Long> systemIds, @Param("componentSource") Integer componentSource);
}