package com.digiwin.athena.semc.mapper.temp;


import com.baomidou.mybatisplus.annotation.InterceptorIgnore;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.digiwin.athena.semc.entity.temp.TemplateTenantGroupItem;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 **/
public interface TemplateTenantGroupItemMapper extends BaseMapper<TemplateTenantGroupItem> {

    /**
     * 条件查询分组下租户
     * @param groupId
     * @param tenantNameId
     * @return
     */
    List<TemplateTenantGroupItem> selectByParam(@Param("groupId")Long  groupId,@Param("tenantNameId")String  tenantNameId);

    /**
     * 根据分组ID查询分组下租户
     * @param groupIdList
     * @return
     */
    @InterceptorIgnore(tenantLine = "true")
   List<TemplateTenantGroupItem> selectByGroup(@Param("groupIdList")List<String> groupIdList);

    /**
     * 批量删除分组下的租户
     *
     */
    Integer delTenantBy(@Param("groupId")Long groupId,@Param("noDelIdList")List<Long> noDelIdList);

    /**
     * 批量保存组下的租户
     *
     * @param paramList
     * @return
     */
    Integer batchInsert(@Param("req") List<TemplateTenantGroupItem> paramList, @Param("groupId")Long groupId);

    /**
     * 删除分组中的租户
     * @return
     */
    @InterceptorIgnore(tenantLine = "true")
    Integer delGroupItem(@Param("groupId")Long groupId,@Param("subTenantIds")List<String> subTenantIds);

    /**
     * 批量删除分组中的租户
     * @return
     */
    @InterceptorIgnore(tenantLine = "true")
    Integer batDelGroupItem(@Param("groupIdList")List<Long> groupIdList,@Param("subTenantIds")List<String> subTenantIds);
}