package com.digiwin.athena.semc.mapper.temp;


import com.baomidou.mybatisplus.annotation.InterceptorIgnore;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.digiwin.athena.semc.entity.temp.TemplateTenantGroup;
import com.digiwin.athena.semc.vo.temp.TemplateTenantGroupVO;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 **/
public interface TemplateTenantGroupMapper extends BaseMapper<TemplateTenantGroup> {


    /**
     * 查询订阅用户下的分组信息
     * @param subUserId
     * @return
     */
    @InterceptorIgnore(tenantLine = "true")
    List<TemplateTenantGroup> selectTenantGroup(@Param("subUserId")String subUserId);


    /**
     * 批量启用停用
     * @param req
     * @param idList
     * @return
     */
    Integer updateStatus(@Param("req")TemplateTenantGroup req,@Param("idList")List<Long> idList);

    /**
     * 根据id批量查询分组并且按id的顺序返回
     * @param idList
     * @return
     */
    @InterceptorIgnore(tenantLine = "true")
    List<TemplateTenantGroupVO> selectByIds(@Param("idList")List<String> idList);

    /**
     * 根据id批量查询分组并且按id
     * @param idList
     * @return
     */
    @InterceptorIgnore(tenantLine = "true")
    List<TemplateTenantGroup> selectByParam(@Param("idList")List<String> idList);

}