package com.digiwin.athena.semc.mapper.temp;


import com.baomidou.mybatisplus.annotation.InterceptorIgnore;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.digiwin.athena.semc.entity.temp.TemplateUserTenant;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 **/
public interface TemplateUserTenantMapper extends BaseMapper<TemplateUserTenant> {



    /**
     * 批量保存
     *
     * @param paramList
     * @return
     */
    int batchInsert(@Param("req")List<TemplateUserTenant> paramList,@Param("mappingId")Long mappingId);


    /**
     * 条件查询用户下租户
     * @param mappingId
     * @param tenantNameId
     * @return
     */
    List<TemplateUserTenant> selectByParam(@Param("mappingId")Long mappingId,@Param("tenantNameId")String tenantNameId);

    /**
     * 查询登录用户关联的所有租户
     * @param subUserIdList
     * @return
     */
    @InterceptorIgnore(tenantLine = "true")
    List<TemplateUserTenant> selectByUserId(@Param("subUserIdList")List<String> subUserIdList);
}