package com.digiwin.athena.semc.mq.dto;

import com.digiwin.athena.semc.common.enums.MQMessageTypeEnum;

import lombok.Data;

@Data
public class MQMessageDTO {

    /**
     * 消息id（全局唯一标识）
     */
    private String messageId;

    /**
     * 消息内容（一般是json）
     */
    private String message;

    /**
     * 消息类型
     * @see MQMessageTypeEnum
     */
    private Integer messageType;

    /**
     * 消息最大重试次数（为空或者0表示不重试）
     */
    private Integer retryMaxCount;
}
