package com.digiwin.athena.semc.mq.sender;


import com.alibaba.fastjson.JSON;
import com.digiwin.athena.semc.configuration.RabbitConfig;
import com.digiwin.athena.semc.mq.dto.MQMessageDTO;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.MDC;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageBuilder;
import org.springframework.amqp.core.MessageDeliveryMode;
import org.springframework.amqp.core.ReturnedMessage;
import org.springframework.amqp.rabbit.connection.CorrelationData;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.stereotype.Component;

import java.nio.charset.StandardCharsets;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;

import cn.hutool.core.util.IdUtil;
import lombok.extern.slf4j.Slf4j;

@Slf4j
@Component
public class RabbitMessageSender implements RabbitTemplate.ConfirmCallback, RabbitTemplate.ReturnsCallback{

    @Resource
    private RabbitTemplate rabbitTemplate;

    @PostConstruct
    public void init() {
        rabbitTemplate.setConfirmCallback(this);
        rabbitTemplate.setReturnsCallback(this);
    }


    /**
     * 发送通用工作消息
     * @param messageDTO
     */
    public void sendWorkCommonMsg(MQMessageDTO messageDTO){
        if (StringUtils.isBlank(messageDTO.getMessageId())) {
            messageDTO.setMessageId(IdUtil.randomUUID());
        }
        log.info("sendWorkCommonMsg：{}",JSON.toJSONString(messageDTO));
        Message message = MessageBuilder.withBody(JSON.toJSONString(messageDTO).getBytes(StandardCharsets.UTF_8))
                .setDeliveryMode(MessageDeliveryMode.PERSISTENT) //消息持久化
                .setHeader("mdc_context", MDC.getCopyOfContextMap())
                .build();
        CorrelationData correlationData = new CorrelationData(messageDTO.getMessageId());
        rabbitTemplate.convertAndSend("", RabbitConfig.SEMC_WORK_COMMON_QUEUE_NAME, message, correlationData);
    }




    @Override
    public void confirm(CorrelationData correlationData, boolean ack, String cause) {
        if (ack) {
            log.info("MQ消息发送成功：{}",correlationData.getId());
        } else {
            log.error("MQ消息发送失败：{}",cause);
        }
    }


    /**
     * 消息从 交换机 --> 到 --> 队列，如果失败了（比如说磁盘满），就会回调该方法
     */
    @Override
    public void returnedMessage(ReturnedMessage returned) {
        log.error("returnedMessage：{}",returned);
    }
}
